#define _CRT_SECURE_NO_WARNINGS

//#pragma GCC optimize("O3")

#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <cmath>
#include <map>
#include <string>
#include <unordered_set>
using namespace std;

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;



//#define LOCAL


#ifdef LOCAL
#define FAST_IO ;
#else
#define FAST_IO ios_base::sync_with_stdio(false), cin.tie(0), cout.tie(0);
#endif

#define int ll
#define vec vector
#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define sz(v) (int)(v.size())
#define endl "\n"
#define mp(a, b) make_pair(a, b)
#define lb(a, b) lower_bound(all(a), b)
#define eb emplace_back
#define ub(a, b) upper_bound(all(a), b)

template<class T> istream& operator>>(istream& in, vec<T>& v) {
	for (auto& it : v)
		in >> it;
	return in;
}


int n;
const int N = 4005;
const ld EPS = 1e-6;
int edges = 0, verts = 0;

int sign(ld x) {
	return x < -EPS ? -1 : x > EPS;
}

//int sign(int x) {
//	return x < 0 ? -1 : x > 0;
//}

struct Point {
	ld x, y;
	Point() {};
	Point(ld x, ld y) : x(x), y(y) {};
	bool operator<(const Point& other) const {
		if (sign(x - other.x) == 0)
			return sign(y - other.y) >= 0;
		return sign(x - other.x) == -1;
	}
	Point operator-(const Point& other) const {
		return { x - other.x , y - other.y };
	}
	ld operator*(const Point& other) const {
		return x * other.x + y * other.y;
	}
	ld operator^(const Point& other) const {
		return x * other.y - y * other.x;
	}
};

pair<Point, Point> ss[N];


inline void findKoef(const Point& one, const Point& two, int& a, int& b, int& c) {
	a = one.y - two.y, b = -(one.x - two.x);
	c = -a * one.x - b * one.y;
}

bool pointXsegm(const Point& a, const Point& b, const Point& p) {
	return sign((p - a) ^ (a - b)) == 0 && sign((p - a) * (a - b)) == 0;
}

pair<bool, Point> inter(Point a, Point b,
						Point c, Point d) {
	int aa, bb, cc, a2, b2, c2;
	findKoef(a, b, aa, bb, cc);
	findKoef(c, d, a2, b2, c2);

	if (bb == 0) {
		swap(a, c); swap(b, d);
		swap(aa, a2); swap(bb, b2); swap(cc, c2);
	}

	int znam = a2 * bb - aa * b2;
	//cout << "znam : " << znam << " " << bb << endl;
	if (znam == 0 || bb == 0) return mp(false, Point(-1, -1));
	ld x = (ld)(b2 * cc - bb * c2) / (ld)znam;
	ld y = (ld)(-cc - aa * x) / (ld)bb;
	Point res = Point(x, y);
	//cout << res.x << " " << res.y << endl;
	if (pointXsegm(a, b, res)) return mp(true, res);
	return mp(false, Point(-1, -1));
}

//
//bool isOk(const Point& a, const Point& b, const Point& c, const Point& d) {
//	int one = sign((b - a) ^ (c - a)) * sign((b - a) ^ (d - a));
//	int two = sign((d - c) ^ (a - c)) * sign((d - c) ^ (b - c));
//	if (pointXsegm(a, b, c) || pointXsegm(a, b, d)) return true;
//	if (pointXsegm(c, d, a) || pointXsegm(c, d, b)) return true;
//	return one == -1 && two == -1;
//}

void solve() {
	int ind = 0;
	cin >> n;

	edges = verts = 0;

	set<pair<ld, ld>> inde;
	for (int i = 0; i < n; ++i) {
		cin >> ss[i].first.x >> ss[i].first.y >> ss[i].second.x >> ss[i].second.y;
	}
	for (int i = 0; i < n; ++i) {
		inde.insert(mp(ss[i].first.x, ss[i].first.y));
		inde.insert(mp(ss[i].second.x, ss[i].second.y));
		int cnt = 0;
		//cout << "i : " << i << endl;
		for (int j = 0; j < n; ++j) {
			if (i == j) continue;
			auto bra = inter(ss[i].first, ss[i].second,
							ss[j].first, ss[j].second);
			if (bra.first) {
				inde.insert(mp(bra.second.x, bra.second.y));
				//cout << " " << j << endl;
				++cnt;
			}
		}
		edges += cnt + 1;
	}
	verts = sz(inde);

	//cout << "verts : " << verts << " edges : " << edges << endl;
	cout << edges + 2 - verts << endl;
}


signed main() {
#ifdef LOCAL
	freopen("C:\\Users\\user\\source\\repos\\Project1\\input.txt", "r", stdin);
#endif
	FAST_IO



	int t; cin >> t;
	while (t--) 
		solve();

}